
markup.push({
	
	// MARK: VU meter block
	
	VUMeterBlock:
	{
		"+": "BlockTemplate",
		geNodeClass: "AHLevelMetersNode",
		gxMenuBarView: "VUMeterStatusItem",
		gxTitle: "VU Meters",
		gxPopoverInfo: "VUMeterPopover",
		gxLibraryDescription: "View a stereo VU meter",
		gxLibraryIcon: "library.meter.vu",
		gxChildViews:
		{
			leftMeter: {
				nsClass: "AH4VUMeterView",
				gxValueKey: "node.rmsLeftDecibels",
				gxForePainter: fillPainter("ForeColorTheme1"),	// needle color
				gxRootLayer: { "+": "VUMeterRootLayer.blockFace" },
				gxAnimateOnKey: "running",
				gxFrameRect: "14,29,92,46"
			},
			rightMeter: {
				nsClass: "AH4VUMeterView",
				gxValueKey: "node.rmsRightDecibels",
				gxForePainter: fillPainter("ForeColorTheme1"),	// needle color
				gxRootLayer: { "+": "VUMeterRootLayer.blockFace" },
				gxAnimateOnKey: "running",
				gxFrameRect: "14,65,92,46"
			},
			leftLabel: {
				"+": "LabelView.foreColorTheme1.top.left.size11",
				gxDefaultValue: "L",
				gxFrameRect: "24,58,8,14"
			},
			rightLabel: {
				"+": "LabelView.foreColorTheme1.top.left.size11",
				gxDefaultValue: "R",
				gxFrameRect: "24,94,8,14"
			},
		}
	},

	// MARK: VU back painter

	VUMeterRootLayer:
	{
		nsClass: "GXDrawLayer",
		gxBackPainter: "VUBackPainter",
		gxSublayers:
		{
			needle: {
				nsClass: "CAShapeLayer",
				gxMaskLayer:
				{
					nsClass: "GXDrawLayer",
					gxBackPainter: "VUBackPainter",
				},
			},
		},
	},

	VUBackPainter:
	{
		nsClass: "AH4VUBackPainter",
		gxFaceColor: "BackColor2",
		gxFaceStrokeColor: "BackColor3",
		gxFontColor: "ForeColor2",
        gxPeakColor: errorColor(95),
		blockFace: {
			gxFaceColor: "ColorTheme2",
			gxFaceStrokeColor: "ColorTheme2",
		},
		showLabels: {
			gxDrawLabels: true,
		}
	},

	// MARK: VU meter popover

	VUMeterPopover: {
		"+": "PopoverTemplate",
		gxTitle: "VU Meters",
		gxLayout: [
			"H:|-12-[self]-12-|",
			"V:|-12-[self]-12-|",

			"V:|-41-[leftMeter(90)]",
			"V:|-41-[rightMeter(90)]",
			"V:|-114-[leftLabel]",

			"H:|-12-[leftMeter(180)]-12-[rightMeter(180)]-12-|",
			"H:|-92-[leftLabel(20)]-172-[rightLabel(20)]&alignBaseline",

			"H:|-25-[showInMenubar(200)]",
			"V:[leftLabel]-6-[showInMenubar]-12-|"
		],
		gxChildViews:
		{
			title: "PopoverTitle",
			onOff: "PopoverOnOffSwitch",
			leftMeter: {
				nsClass: "AH4VUMeterView",
				gxValueKey: "node.rmsLeftDecibels",
				gxForePainter: fillPainter("ForeColor1"),	// needle color
				gxRootLayer: { "+": "VUMeterRootLayer.showLabels" },
				gxAnimateOnKey: "running",
			},
			rightMeter: {
				nsClass: "AH4VUMeterView",
				gxValueKey: "node.rmsRightDecibels",
				gxForePainter: fillPainter("ForeColor1"),	// needle color
				gxRootLayer: { "+": "VUMeterRootLayer.showLabels" },
				gxAnimateOnKey: "running",
			},
			leftLabel: {
				"+": "LabelView.centerx.size12",
				gxDefaultValue: "L",
				gxLayerZPosition: 10,
			},
			rightLabel: {
				"+": "LabelView.centerx.size12",
				gxDefaultValue: "R",
				gxLayerZPosition: 10,
			},
			showInMenubar: {
				"+": "CheckboxTemplate",
				gxTitle: "<checkbox/> Show in menu bar",
				gxValueKey: "showMenuItem",
			},
		},
	},

	
	// MARK: menu bar meter

	VUMeterStatusItem:
	{
		nsClass: "GXMenuBarView",
		gxLayout:
		[
			"V:|-0-[self(23)]-0-|",
			"H:|-2-[self]-2-|",

			"V:|-1-[leftMeter(20)]",
			"V:|-1-[rightMeter(20)]",
			//"V:|-114-[leftLabel]",

			"H:|-0-[leftMeter(40)]-(-2)-[rightMeter(40)]-0-|",
			//"H:|-92-[leftLabel(20)]-172-[rightLabel(20)]&alignBaseline",
		],
		gxChildViews:
		{
			leftMeter: {
				nsClass: "AH4VUMeterView",
				gxValueKey: "node.rmsLeftDecibels",
				gxForePainter: fillPainter("ForeColor1"),	// needle color
				gxRootLayer: { "+": "VUMeterRootLayer" },
				gxAnimateOnKey: "running",
			},
			rightMeter: {
				nsClass: "AH4VUMeterView",
				gxValueKey: "node.rmsRightDecibels",
				gxForePainter: fillPainter("ForeColor1"),	// needle color
				gxRootLayer: { "+": "VUMeterRootLayer" },
				gxAnimateOnKey: "running",
			},
		}
	},

})
